	[G, Z, P] = CH_II_POLES_Z2(Wc, Ws, Amax, Amin, N)
	
	% The poles and zeros of the inverse Chebyshev filter are determined 
	% according to A - see pages 230 - 235 in Rabiner and Gold,
	% Theory and Application of Digital Signal Processing), but now the
	% specifications are given in terms of N, Omega_p = tan(omega_p/2), 
	% Omega_s = tan(omega_s/2), and A_p (epsilon^2 = sqrt(10^(Ap/10)-1)).
	% This is not a problem because the Chebyshev and inverse Chebyshev
	% filter meet the same criteria. For the Chebyshev filter,
	% |H(jOmega)|^2  = 1/[1+epsilon^2*{cosh[N*acosh(Omega)]}^2].
	% Hence, 1/(A^2) = 1/[1+epsilon^2*{cosh[N*acosh(Omega_s]}^2].
	% --> A^2 = 1+epsilon^2*{cosh[N*acosh(Omega_s]}^2
	% earlier epsilon2
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-08
	% 	Modified by: 	LW
	% 	Version: 		1
	% 	Known bugs:
	% 	Copyright:		by authors - not released for commercial use	
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	aconstant = tan(omega_p*pi/2);
	%-----------------------------------------------------------  
	epsilon = sqrt(10^(Amax/10)-1);
	Omegas = tan(wsT/2)/tan(wcT/2);
	stop = N*acosh(Omegas);
	stop = epsilon*cosh(stop);
	stop = 1/(1+stop^2);
	%------------------------------------------------------------
	% 1/A^2 = stop ----->
	%------------------------------------------------------------
	A = 1/stop;
	A = sqrt(A);
	% Hopefully - test later
	% A = sqrt(1+epsilon^2*cosh(N*acosh(Omega_s))^2);
	%-------------------------------------------------------------
	% Now we are ready to find out the poles and zeros
	%------------------------------------------------------------
	% First poles
	%------------------------------------------------------------
	gamma = A+sqrt(A^2-1);
	gamma = gamma^(1/N);
	gamma1 = -(gamma-1/gamma)/2;
	gamma2 = (gamma+1/gamma)/2;
	k = 1:N;
	a = (2*k-1)*pi/(2*N);
	alpha = gamma1*sin(a);
	beta = gamma2*cos(a);
	den = alpha.*alpha+beta.*beta;
	pol = Omegas*alpha-j*Omegas*beta;
	pol = pol./den;
	P = (1+aconstant*pol)./(1-aconstant*pol);
	%------------------------------------------------------------
	% Then zeros; only zeros on the upper half plane are considered
	%------------------------------------------------------------
	% M = N/2;
	% if rem(N,2) == 1 M = (N-1)/2;end
	%k = 1:M
	% a = pi*(2*k-1)/(2*N);
	% a = cos(a);
	% zer = Omegas*ones(size(a))./a;
	% zer = 2*atan(zer*aconstant);
	% zero_angles(2*kk-1) = -zer(kk);
	% zero_angles(2*kk) = zer(kk);
	% if rem(N,2) == 1
	%   zero_angles(N) = pi;
	% end
	kk = 1:floor(N/2);
	a = pi*(2*kk-1)/(2*N);
	a = cos(a);
	zer = Omegas*ones(size(a))./a;
	zer = 2*atan(zer*aconstant);
	zero_angles(2*kk-1) = -zer(kk);
	zero_angles(2*kk) = zer(kk);
	if rem(N,2) == 1
		zero_angles(N) = pi;
	end
	Z = exp(j*zero_angles);
	G = real(prod(1-P))/real(prod(1-Z));
	
